<?php
/**
 *
 * @category        framework
 * @package         language
 * @author          WebsiteBaker Project
 * @copyright       2004-2009, Ryan Djurovich
 * @copyright       2009-2011, Website Baker Org. e.V.
 * @link			http://www.websitebaker2.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.8.x
 * @requirements    PHP 5.2.2 and higher
 * @version         $Id: PT.php 1636 2012-03-09 14:30:29Z Luisehahne $
 * @filesource		$HeadURL: svn://isteam.dynxs.de/wb_svn/wb280/branches/2.8.x/wb/languages/PT.php $
 * @lastmodified    $Date: 2012-03-09 15:30:29 +0100 (Fr, 09. Mrz 2012) $
 *
 */

// Must include code to stop this file being access directly
if(defined('WB_PATH') == false) { exit("Cannot access this file directly"); }

// Define that this file is loaded
if(!defined('LANGUAGE_LOADED')) {
define('LANGUAGE_LOADED', true);
}

// Set the language information
$language_code = 'PT';
$language_name = 'Portuguese (Brazil)';
$language_version = '2.8';
$language_platform = '2.8.x';
$language_author = 'Daniel Neto';
$language_license = 'GNU General Public License';
$MENU['ACCESS'] = 'Acessos';
$MENU['ADDON'] = 'Add-on';
$MENU['ADDONS'] = 'Add-ons';
$MENU['ADMINTOOLS'] = 'Admin-Tools';
$MENU['BREADCRUMB'] = 'You are here: ';
$MENU['FORGOT'] = 'Receber Detalhes do Login';
$MENU['GROUP'] = 'Group';
$MENU['GROUPS'] = 'Grupos';
$MENU['HELP'] = 'Ajuda';
$MENU['LANGUAGES'] = 'Idiomas';
$MENU['LOGIN'] = 'Login';
$MENU['LOGOUT'] = 'Log-out';
$MENU['MEDIA'] = 'M&iacute;dia';
$MENU['MODULES'] = 'M&oacute;dulos';
$MENU['PAGES'] = 'P&aacute;ginas';
$MENU['PREFERENCES'] = 'Prefer&ecirc;ncias';
$MENU['SETTINGS'] = 'Configura&ccdil;&otilde;es';
$MENU['START'] = 'In&iacute;cio';
$MENU['TEMPLATES'] = 'Temas (Templates)';
$MENU['USERS'] = 'Usu&aacute;rios';
$MENU['VIEW'] = 'Visualizar';
$TEXT['ACCOUNT_SIGNUP'] = 'Assinatura de Conta';
$TEXT['ACTIONS'] = 'A&ccdil;&otilde;es';
$TEXT['ACTIVE'] = 'Ativo';
$TEXT['ADD'] = 'Adicionar';
$TEXT['ADDON'] = 'Add-On';
$TEXT['ADD_SECTION'] = 'Adicionar Sess&atilde;o';
$TEXT['ADMIN'] = 'Admin';
$TEXT['ADMINISTRATION'] = 'Administra&ccdil;&atilde;o';
$TEXT['ADMINISTRATION_TOOL'] = 'Ferramenta de Administra&ccdil;&atilde;o';
$TEXT['ADMINISTRATOR'] = 'Administrator';
$TEXT['ADMINISTRATORS'] = 'Administrators';
$TEXT['ADVANCED'] = 'Avan&ccdil;ado';
$TEXT['ALLOWED_FILETYPES_ON_UPLOAD'] = 'Allowed filetypes on upload';
$TEXT['ALLOWED_VIEWERS'] = 'Allowed Viewers';
$TEXT['ALLOW_MULTIPLE_SELECTIONS'] = 'Permitir Multipla Sele&ccdil;&atilde;o';
$TEXT['ALL_WORDS'] = 'Todas as Palavras';
$TEXT['ANCHOR'] = 'Anchor';
$TEXT['ANONYMOUS'] = 'An&ocirc;nimo';
$TEXT['ANY_WORDS'] = 'Qualquer Palavra';
$TEXT['APP_NAME'] = 'Nome da Aplica&ccdil;&atilde;o';
$TEXT['ARE_YOU_SURE'] = 'Voc&ecirc; tem certeza?';
$TEXT['AUTHOR'] = 'Autor';
$TEXT['BACK'] = 'Volta';
$TEXT['BACKUP'] = 'Backup';
$TEXT['BACKUP_ALL_TABLES'] = 'Backup de Todas as Tabelas no Banco de Dados';
$TEXT['BACKUP_DATABASE'] = 'Backup do Banco de Dados';
$TEXT['BACKUP_MEDIA'] = 'Backup M&iacute;dia';
$TEXT['BACKUP_WB_SPECIFIC'] = 'Backup somente tabelas espec&iacute;ficas';
$TEXT['BASIC'] = 'B&aacute;sico';
$TEXT['BLOCK'] = 'Block';
$TEXT['CALENDAR'] = 'Calender';
$TEXT['CANCEL'] = 'Cancelar';
$TEXT['CAN_DELETE_HIMSELF'] = 'Can delete himself';
$TEXT['CAPTCHA_VERIFICATION'] = 'Verifica&ccdil;&atilde;o Captcha';
$TEXT['CAP_EDIT_CSS'] = 'Edit CSS';
$TEXT['CHANGE'] = 'Alterar';
$TEXT['CHANGES'] = 'Altera&ccdil;&otilde;es';
$TEXT['CHANGE_SETTINGS'] = 'Alterar Configura&ccdil;&otilde;es';
$TEXT['CHARSET'] = 'Charset';
$TEXT['CHECKBOX_GROUP'] = 'Checkbox Group';
$TEXT['CLOSE'] = 'Fechar';
$TEXT['CODE'] = 'C&oacute;digo';
$TEXT['CODE_SNIPPET'] = 'Code-snippet';
$TEXT['COLLAPSE'] = 'Collapse';
$TEXT['COMMENT'] = 'Coment&aacute;rio';
$TEXT['COMMENTING'] = 'Coment&aacute;rios';
$TEXT['COMMENTS'] = 'Coment&aacute;rios';
$TEXT['CREATE_FOLDER'] = 'Criar Pasta';
$TEXT['CURRENT'] = 'Atual';
$TEXT['CURRENT_FOLDER'] = 'Pasta Atual';
$TEXT['CURRENT_PAGE'] = 'P&aacute;gina Atual';
$TEXT['CURRENT_PASSWORD'] = 'Senha Atual';
$TEXT['CUSTOM'] = 'Pr&oacute;prio';
$TEXT['DATABASE'] = 'Banco de Dados';
$TEXT['DATE'] = 'Data';
$TEXT['DATE_FORMAT'] = 'Formato de Data';
$TEXT['DEFAULT'] = 'Padr&atilde;o';
$TEXT['DEFAULT_CHARSET'] = 'Codifica&ccdil;&atilde;o Padr&atilde;o';
$TEXT['DEFAULT_TEXT'] = 'Testo Padr&atilde;o';
$TEXT['DELETE'] = 'Apagar';
$TEXT['DELETED'] = 'Apagado';
$TEXT['DELETE_DATE'] = 'Delete date';
$TEXT['DELETE_ZIP'] = 'Delete zip archive after unpacking';
$TEXT['DESCRIPTION'] = 'Descri&ccdil;&atilde;o';
$TEXT['DESIGNED_FOR'] = 'Designado para';
$TEXT['DIRECTORIES'] = 'Diret&oacute;rios';
$TEXT['DIRECTORY_MODE'] = 'Modo de Diret&oacute;rio';
$TEXT['DISABLED'] = 'Desabilitado';
$TEXT['DISPLAY_NAME'] = 'Nome de Exibi&ccdil;&atilde;o';
$TEXT['EMAIL'] = 'Email';
$TEXT['EMAIL_ADDRESS'] = 'Endre&ccdil;or de Email';
$TEXT['EMPTY_TRASH'] = 'Esvaziar Lixeira';
$TEXT['ENABLED'] = 'Habilitado';
$TEXT['END'] = 'Fim';
$TEXT['ERROR'] = 'Erro';
$TEXT['EXACT_MATCH'] = 'Express&atilde;o Exata';
$TEXT['EXECUTE'] = 'Executar';
$TEXT['EXPAND'] = 'Expand';
$TEXT['EXTENSION'] = 'Extension';
$TEXT['FIELD'] = 'Campo';
$TEXT['FILE'] = 'Arquivo';
$TEXT['FILES'] = 'Arquivos';
$TEXT['FILESYSTEM_PERMISSIONS'] = 'Permiss&otilde;es de Sistema de Arquivos';
$TEXT['FILE_MODE'] = 'Modo de Arquivo';
$TEXT['FINISH_PUBLISHING'] = 'Finish Publishing';
$TEXT['FOLDER'] = 'Pasta';
$TEXT['FOLDERS'] = 'Pastas';
$TEXT['FOOTER'] = 'Rodap&eacute;';
$TEXT['FORGOTTEN_DETAILS'] = 'Esqueceu suas credenciais?';
$TEXT['FORGOT_DETAILS'] = 'Esqueceu as credenciais?';
$TEXT['FROM'] = 'De';
$TEXT['FRONTEND'] = 'Front-end';
$TEXT['FULL_NAME'] = 'Nome Completo';
$TEXT['FUNCTION'] = 'Function';
$TEXT['GROUP'] = 'Grupo';
$TEXT['HEADER'] = 'Cabe&ccdil;alho';
$TEXT['HEADING'] = 'Cabe&ccdil;alho';
$TEXT['HEADING_CSS_FILE'] = 'Actual module file: ';
$TEXT['HEIGHT'] = 'Largura';
$TEXT['HIDDEN'] = 'Oculto';
$TEXT['HIDE'] = 'Ocultar';
$TEXT['HIDE_ADVANCED'] = 'Ocultar Op&ccdil;&otilde;es Avan&ccdil;adas';
$TEXT['HOME'] = 'Home';
$TEXT['HOMEPAGE_REDIRECTION'] = 'Redirecionamento de P&aacute;gina';
$TEXT['HOME_FOLDER'] = 'Personal Folder';
$TEXT['HOME_FOLDERS'] = 'Personal Folders';
$TEXT['HOST'] = 'Host';
$TEXT['ICON'] = '&Iacute;cone';
$TEXT['IMAGE'] = 'Imagem';
$TEXT['INLINE'] = 'In-line';
$TEXT['INSTALL'] = 'Instalar';
$TEXT['INSTALLATION'] = 'Instala&ccdil;&atilde;o';
$TEXT['INSTALLATION_PATH'] = 'Caminho de Instala&ccdil;&atilde;o';
$TEXT['INSTALLATION_URL'] = 'URL de Instala&ccdil;&atilde;o';
$TEXT['INSTALLED'] = 'installed';
$TEXT['INTRO'] = 'Introdu&ccdil;&atilde;o';
$TEXT['INTRO_PAGE'] = 'P&aacute;gina de Introdu&ccdil;&atilde;o';
$TEXT['INVALID_SIGNS'] = 'must begin with a letter or has invalid signs';
$TEXT['KEYWORDS'] = 'Keywords';
$TEXT['LANGUAGE'] = 'Idioma';
$TEXT['LAST_UPDATED_BY'] = '&Uacute;ltima atualiza&ccdil;&atilde;o por';
$TEXT['LENGTH'] = 'Tamanho';
$TEXT['LEVEL'] = 'N&iacute;vel';
$TEXT['LINK'] = 'Link';
$TEXT['LINUX_UNIX_BASED'] = 'Linux/Unix based';
$TEXT['LIST_OPTIONS'] = 'Op&ccdil;&otilde;es de Lista';
$TEXT['LOGGED_IN'] = 'Logado';
$TEXT['LOGIN'] = 'Login';
$TEXT['LONG'] = 'Longo';
$TEXT['LONG_TEXT'] = 'Texto Longo';
$TEXT['LOOP'] = 'La&ccdil;o de Repeti&ccdil;&atilde;o';
$TEXT['MAIN'] = 'Principal';
$TEXT['MAINTENANCE_OFF'] = 'Maintenance off';
$TEXT['MAINTENANCE_ON'] = 'Maintenance on';
$TEXT['MANAGE'] = 'Gerenciar';
$TEXT['MANAGE_GROUPS'] = 'Gerenciar Grupos';
$TEXT['MANAGE_USERS'] = 'Gerenciar Usu&aacute;rios';
$TEXT['MATCH'] = 'Possua';
$TEXT['MATCHING'] = 'Matching';
$TEXT['MAX_EXCERPT'] = 'Max lines of excerpt';
$TEXT['MAX_SUBMISSIONS_PER_HOUR'] = 'Max. Submiss&otilde;es por Hora';
$TEXT['MEDIA_DIRECTORY'] = 'Diret&oacute;rio de M&iacute;dia';
$TEXT['MENU'] = 'Menu';
$TEXT['MENU_ICON_0'] = 'Menu-Icon normal';
$TEXT['MENU_ICON_1'] = 'Menu-Icon hover';
$TEXT['MENU_TITLE'] = 'T&iacute;tulo do Menu';
$TEXT['MESSAGE'] = 'Mensagem';
$TEXT['MODIFY'] = 'Modificar';
$TEXT['MODIFY_CONTENT'] = 'Modificar Conte&uacute;do';
$TEXT['MODIFY_SETTINGS'] = 'Modificar Configura&ccdil;&otilde;es';
$TEXT['MODULE_ORDER'] = 'Module-order for searching';
$TEXT['MODULE_PERMISSIONS'] = 'Permiss&otilde;es de M&oacute;dulo';
$TEXT['MORE'] = 'Mais';
$TEXT['MOVE_DOWN'] = 'Mover para Baixo';
$TEXT['MOVE_UP'] = 'Mover para Cima';
$TEXT['MULTIPLE_MENUS'] = 'M&uacute;ltiplos Menus';
$TEXT['MULTISELECT'] = 'Multipla-Sele&ccdil;&atilde;o';
$TEXT['NAME'] = 'Nome';
$TEXT['NEED_CURRENT_PASSWORD'] = 'confirm with current password';
$TEXT['NEED_TO_LOGIN'] = 'Precisar fazer log-in?';
$TEXT['NEW_PASSWORD'] = 'Nova Senha';
$TEXT['NEW_WINDOW'] = 'New Window';
$TEXT['NEXT'] = 'Pr&oacute;ximo';
$TEXT['NEXT_PAGE'] = 'Pr&oacute;xima P&aacute;gina';
$TEXT['NO'] = 'N&atilde;o';
$TEXT['NONE'] = 'Nenhum';
$TEXT['NONE_FOUND'] = 'Nada Encontrado';
$TEXT['NOT_FOUND'] = 'N&atilde;o Encotnrado';
$TEXT['NOT_INSTALLED'] = 'not installed';
$TEXT['NO_IMAGE_SELECTED'] = 'no image selected';
$TEXT['NO_RESULTS'] = 'Sem Resultados';
$TEXT['OF'] = 'de';
$TEXT['ON'] = 'On';
$TEXT['OPEN'] = 'Open';
$TEXT['OPTION'] = 'Op&ccdil;&atilde;o';
$TEXT['OTHERS'] = 'Outros';
$TEXT['OUT_OF'] = 'Out Of';
$TEXT['OVERWRITE_EXISTING'] = 'Substituir Existente';
$TEXT['PAGE'] = 'P&aacute;gina';
$TEXT['PAGES_DIRECTORY'] = 'Diret&oacute;rio de P&aacute;ginas';
$TEXT['PAGES_PERMISSION'] = 'Pages Permission';
$TEXT['PAGES_PERMISSIONS'] = 'Pages Permissions';
$TEXT['PAGE_EXTENSION'] = 'Extens&atilde;o da P&aacute;gina';
$TEXT['PAGE_ICON'] = 'Page Image';
$TEXT['PAGE_ICON_DIR'] = 'Path pages/menu images';
$TEXT['PAGE_LANGUAGES'] = 'Idioma da P&aacute;gina';
$TEXT['PAGE_LEVEL_LIMIT'] = 'Limite de N&iacute;veis de P&aacute;gina';
$TEXT['PAGE_SPACER'] = 'Espa&ccdil;ador de P&aacute;gina';
$TEXT['PAGE_TITLE'] = 'T&iacute;tulo da P&aacute;gina';
$TEXT['PAGE_TRASH'] = 'Page Trash';
$TEXT['PARENT'] = 'Parent';
$TEXT['PASSWORD'] = 'Senha';
$TEXT['PATH'] = 'Caminho';
$TEXT['PHP_ERROR_LEVEL'] = 'PHP Error Reporting Level';
$TEXT['PLEASE_LOGIN'] = 'Please login';
$TEXT['PLEASE_SELECT'] = 'Por Favor escolha';
$TEXT['POST'] = 'Post';
$TEXT['POSTS_PER_PAGE'] = 'Posts por P&aacute;gina';
$TEXT['POST_FOOTER'] = 'Rodap&eacute; do Post';
$TEXT['POST_HEADER'] = 'Cabe&ccdil;alho do Post';
$TEXT['PREVIOUS'] = 'Anterior';
$TEXT['PREVIOUS_PAGE'] = 'P&aacute;gina Anterior';
$TEXT['PRIVATE'] = 'Privado';
$TEXT['PRIVATE_VIEWERS'] = 'Private Viewers';
$TEXT['PROFILES_EDIT'] = 'Change the profile';
$TEXT['PUBLIC'] = 'P&uacute;blico';
$TEXT['PUBL_END_DATE'] = 'End date';
$TEXT['PUBL_START_DATE'] = 'Start date';
$TEXT['RADIO_BUTTON_GROUP'] = 'Radio Button Group';
$TEXT['READ'] = 'Ler';
$TEXT['READ_MORE'] = 'Leia Mais';
$TEXT['REDIRECT_AFTER'] = 'Redirect after';
$TEXT['REGISTERED'] = 'Registrado';
$TEXT['REGISTERED_VIEWERS'] = 'Registered Viewers';
$TEXT['RELOAD'] = 'Recarregar';
$TEXT['REMEMBER_ME'] = 'Lembrar-me';
$TEXT['RENAME'] = 'Renomear';
$TEXT['RENAME_FILES_ON_UPLOAD'] = 'No upload for this filetypes';
$TEXT['REQUIRED'] = 'Requerido';
$TEXT['REQUIREMENT'] = 'Requirement';
$TEXT['RESET'] = 'Redefinir';
$TEXT['RESIZE'] = 'Redimentsionar';
$TEXT['RESIZE_IMAGE_TO'] = 'Redimensionar Imagem Para';
$TEXT['RESTORE'] = 'Restaurar';
$TEXT['RESTORE_DATABASE'] = 'Restaurar Banco de Dados';
$TEXT['RESTORE_MEDIA'] = 'Restaurar M&iacute;dia';
$TEXT['RESULTS'] = 'Resultados';
$TEXT['RESULTS_FOOTER'] = 'Rodap&eacute; dos Resultados';
$TEXT['RESULTS_FOR'] = 'Resultados para';
$TEXT['RESULTS_HEADER'] = 'Cabe&ccdil;alho dos Resultados';
$TEXT['RESULTS_LOOP'] = 'La&ccdil;o de Repeti&ccdil;&atilde;o dos Resultados';
$TEXT['RETYPE_NEW_PASSWORD'] = 'Confirme a Nova Senha';
$TEXT['RETYPE_PASSWORD'] = 'Confirme a Senha';
$TEXT['SAME_WINDOW'] = 'Same Window';
$TEXT['SAVE'] = 'Salvar';
$TEXT['SEARCH'] = 'Busca';
$TEXT['SEARCHING'] = 'Buscando';
$TEXT['SECTION'] = 'Sess&atilde;o';
$TEXT['SECTION_BLOCKS'] = 'Section Blocks';
$TEXT['SEC_ANCHOR'] = 'Section-Anchor text';
$TEXT['SELECT_BOX'] = 'Select Box';
$TEXT['SEND_DETAILS'] = 'Enviar credenciais';
$TEXT['SEPARATE'] = 'Separado';
$TEXT['SEPERATOR'] = 'Separador';
$TEXT['SERVER_EMAIL'] = 'Servidor de Email';
$TEXT['SERVER_OPERATING_SYSTEM'] = 'Sistema Operacional do Servidor';
$TEXT['SESSION_IDENTIFIER'] = 'Identificador de Sess&atilde;o';
$TEXT['SETTINGS'] = 'Configura&ccdil;&otilde;es';
$TEXT['SHORT'] = 'Curto';
$TEXT['SHORT_TEXT'] = 'Texto Curto';
$TEXT['SHOW'] = 'Exibir';
$TEXT['SHOW_ADVANCED'] = 'Exibir Op&ccdil;&otilde;es Avan&ccdil;adas';
$TEXT['SIGNUP'] = 'Inscrever';
$TEXT['SIZE'] = 'Tamanho';
$TEXT['SMART_LOGIN'] = 'Login Inteligente';
$TEXT['START'] = 'In&iacute;cio';
$TEXT['START_PUBLISHING'] = 'Start Publishing';
$TEXT['SUBJECT'] = 'Assunto';
$TEXT['SUBMISSIONS'] = 'Submiss&otilde;es';
$TEXT['SUBMISSIONS_STORED_IN_DATABASE'] = 'Submiss&otilde;es armazenadas no banco de dados';
$TEXT['SUBMISSION_ID'] = 'Submission ID';
$TEXT['SUBMITTED'] = 'Submetido';
$TEXT['SUCCESS'] = 'Sucesso';
$TEXT['SYSTEM_DEFAULT'] = 'Padr&atilde;o do Sistema';
$TEXT['SYSTEM_PERMISSIONS'] = 'Permiss&otilde;es de Sistema';
$TEXT['TABLE_PREFIX'] = 'Prefixo da Tabela';
$TEXT['TARGET'] = 'Target';
$TEXT['TARGET_FOLDER'] = 'Pasta Alvo';
$TEXT['TEMPLATE'] = 'Tema (Template)';
$TEXT['TEMPLATE_PERMISSIONS'] = 'Permiss&otilde;es do Tema (Template)';
$TEXT['TEXT'] = 'Texto';
$TEXT['TEXTAREA'] = 'Textarea';
$TEXT['TEXTFIELD'] = 'Textfield';
$TEXT['THEME'] = 'Backend-Theme';
$TEXT['THEME_COPY_CURRENT'] = 'Copy backend theme.';
$TEXT['THEME_CURRENT'] = 'current active theme';
$TEXT['THEME_IMPORT_HTT'] = 'Import additional templates';
$TEXT['THEME_NEW_NAME'] = 'Name of the new Theme';
$TEXT['THEME_NOMORE_HTT'] = 'no more available';
$TEXT['THEME_SELECT_HTT'] = 'select templates';
$TEXT['THEME_START_COPY'] = 'copy';
$TEXT['THEME_START_IMPORT'] = 'import';
$TEXT['TIME'] = 'Hora';
$TEXT['TIMEZONE'] = 'Fuso Hor&aacute;rio';
$TEXT['TIME_FORMAT'] = 'Formato de Hora';
$TEXT['TIME_LIMIT'] = 'Max time to gather excerpts per module';
$TEXT['TITLE'] = 'T&iacute;tulo';
$TEXT['TO'] = 'Para';
$TEXT['TOP_FRAME'] = 'Top Frame';
$TEXT['TRASH_EMPTIED'] = 'Lixiera Vazia';
$TEXT['TXT_EDIT_CSS_FILE'] = 'Edit the CSS definitions in the textarea below.';
$TEXT['TYPE'] = 'Tipo';
$TEXT['UNDER_CONSTRUCTION'] = 'Em Constru&ccdil;&atilde;o';
$TEXT['UNINSTALL'] = 'Desinstalar';
$TEXT['UNKNOWN'] = 'Desconhecido';
$TEXT['UNLIMITED'] = 'Ilimitado';
$TEXT['UNZIP_FILE'] = 'Upload and unpack a zip archive';
$TEXT['UP'] = 'Cima';
$TEXT['UPGRADE'] = 'Upgrade';
$TEXT['UPLOAD_FILES'] = 'Enviar Arquivo(s)';
$TEXT['URL'] = 'URL';
$TEXT['USER'] = 'Usu&aacute;rio';
$TEXT['USERNAME'] = 'Loginname';
$TEXT['USERS_ACTIVE'] = 'User is set active';
$TEXT['USERS_CAN_SELFDELETE'] = 'User can delete himself';
$TEXT['USERS_CHANGE_SETTINGS'] = 'User can change his own settings';
$TEXT['USERS_DELETED'] = 'User is marked as deleted';
$TEXT['USERS_FLAGS'] = 'User-Flags';
$TEXT['USERS_PROFILE_ALLOWED'] = 'User can create extended profile';
$TEXT['VERIFICATION'] = 'Verifica&ccdil;&atilde;o';
$TEXT['VERSION'] = 'Vers&atilde;o';
$TEXT['VIEW'] = 'Ver';
$TEXT['VIEW_DELETED_PAGES'] = 'Exibir P&aacute;ginas Exclu&iacute;das';
$TEXT['VIEW_DETAILS'] = 'Ver Detalhes';
$TEXT['VISIBILITY'] = 'Visibilidade';
$TEXT['WBMAILER_DEFAULT_SENDER_MAIL'] = 'Default From Mail';
$TEXT['WBMAILER_DEFAULT_SENDER_NAME'] = 'Default Sender Name';
$TEXT['WBMAILER_DEFAULT_SETTINGS_NOTICE'] = 'Please specify a default "FROM" address and "SENDER" name below. It is recommended to use a FROM address like: <strong>admin@yourdomain.com</strong>. Some mail provider (e.g. <em>mail.com</em>) may reject mails with a FROM: address like <em>name@mail.com</em> sent via a foreign relay to avoid spam.<br /><br />The default values are only used if no other values are specified by WebsiteBaker. If your server supports <acronym title="Simple mail transfer protocol">SMTP</acronym>, you may want use this option for outgoing mails.';
$TEXT['WBMAILER_FUNCTION'] = 'Mail Routine';
$TEXT['WBMAILER_NOTICE'] = '<strong>SMTP Mailer Settings:</strong><br />The settings below are only required if you want to send mails via <acronym title="Simple mail transfer protocol">SMTP</acronym>. If you do not know your SMTP host or you are not sure about the required settings, simply stay with the default mail routine: PHP MAIL.';
$TEXT['WBMAILER_PHP'] = 'PHP MAIL';
$TEXT['WBMAILER_SMTP'] = 'SMTP';
$TEXT['WBMAILER_SMTP_AUTH'] = 'SMTP Authentification';
$TEXT['WBMAILER_SMTP_AUTH_NOTICE'] = 'only activate if your SMTP host requires authentification';
$TEXT['WBMAILER_SMTP_HOST'] = 'SMTP Host';
$TEXT['WBMAILER_SMTP_PASSWORD'] = 'SMTP Password';
$TEXT['WBMAILER_SMTP_USERNAME'] = 'SMTP Loginname';
$TEXT['WEBSITE'] = 'Website';
$TEXT['WEBSITE_DESCRIPTION'] = 'Descri&ccdil;&atilde;o do Website';
$TEXT['WEBSITE_FOOTER'] = 'Rodap&eacute; do Website';
$TEXT['WEBSITE_HEADER'] = 'Cabe&ccdil;alho do Website';
$TEXT['WEBSITE_KEYWORDS'] = 'Website Keywords';
$TEXT['WEBSITE_TITLE'] = 'T&iacute;tulo do Website';
$TEXT['WELCOME_BACK'] = 'Bem-Vindo';
$TEXT['WIDTH'] = 'Altura';
$TEXT['WINDOW'] = 'Window';
$TEXT['WINDOWS'] = 'Windows';
$TEXT['WORLD_WRITEABLE_FILE_PERMISSIONS'] = 'World-writeable file permissions';
$TEXT['WRITE'] = 'Escrever';
$TEXT['WYSIWYG_EDITOR'] = 'WYSIWYG Editor';
$TEXT['WYSIWYG_STYLE'] = 'WYSIWYG Style';
$TEXT['YES'] = 'Sim';
$HEADING['ADDON_PRECHECK_FAILED'] = 'Add-On requirements not met';
$HEADING['ADD_CHILD_PAGE'] = 'Add child page';
$HEADING['ADD_GROUP'] = 'Adicionar Grupo';
$HEADING['ADD_GROUPS'] = 'Add Groups';
$HEADING['ADD_HEADING'] = 'Adicionar Cabe&ccdil;alho';
$HEADING['ADD_PAGE'] = 'Adicionar P&aacute;gina';
$HEADING['ADD_USER'] = 'Adicionar Usu&aacute;rio';
$HEADING['ADMINISTRATION_TOOLS'] = 'Ferramentas de Administra&ccdil;&atilde;o';
$HEADING['BROWSE_MEDIA'] = 'Navegar pela M&iacute;dia';
$HEADING['CREATE_FOLDER'] = 'Criar Pasta';
$HEADING['DEFAULT_SETTINGS'] = 'Configura&ccdil;&otilde;es Padr&atilde;o';
$HEADING['DELETED_PAGES'] = 'P&aacute;ginas apagadas';
$HEADING['FILESYSTEM_SETTINGS'] = 'Configura&ccdil;&otilde;es de Sistema de Arquivos';
$HEADING['GENERAL_SETTINGS'] = 'Configura&ccdil;&otilde;es Gerais';
$HEADING['INSTALL_LANGUAGE'] = 'Instalar Idioma';
$HEADING['INSTALL_MODULE'] = 'Instalar M&oacute;dulo';
$HEADING['INSTALL_TEMPLATE'] = 'Instalar Tema (Template)';
$HEADING['INVOKE_LANGUAGE_FILES'] = 'Execute language files manually';
$HEADING['INVOKE_MODULE_FILES'] = 'Execute module files manually';
$HEADING['INVOKE_TEMPLATE_FILES'] = 'Execute template files manually';
$HEADING['LANGUAGE_DETAILS'] = 'Detalhes do Idioma';
$HEADING['MANAGE_SECTIONS'] = 'Gerenciar Sess&otilde;es';
$HEADING['MODIFY_ADVANCED_PAGE_SETTINGS'] = 'Modificar Configura&ccdil;&otilde;es Avan&ccdil;adas da P&aacute;gina';
$HEADING['MODIFY_DELETE_GROUP'] = 'Modificar/Apagar Grupo';
$HEADING['MODIFY_DELETE_PAGE'] = 'Modificar/Apagar P&aacute;gina';
$HEADING['MODIFY_DELETE_USER'] = 'Modificar/Apagar Usu&aacute;rio';
$HEADING['MODIFY_GROUP'] = 'Modificar Grupo';
$HEADING['MODIFY_GROUPS'] = 'Modify Groups';
$HEADING['MODIFY_INTRO_PAGE'] = 'Modificar P&aacute;gina de Introdu&ccdil;&atilde;o';
$HEADING['MODIFY_PAGE'] = 'Modificar P&aacute;gina';
$HEADING['MODIFY_PAGE_SETTINGS'] = 'Modificar Configura&ccdil;&otilde;es da P&aacute;gina';
$HEADING['MODIFY_USER'] = 'Modificar Usu&aacute;rio';
$HEADING['MODULE_DETAILS'] = 'Detalhes do M&oacute;dulo';
$HEADING['MY_EMAIL'] = 'Meu Email';
$HEADING['MY_PASSWORD'] = 'Minha Senha';
$HEADING['MY_SETTINGS'] = 'Minhas Configura&ccdil;&otilde;es';
$HEADING['SEARCH_SETTINGS'] = 'Configura&ccdil;&otilde;es de Busca';
$HEADING['SERVER_SETTINGS'] = 'Configura&ccdil;&otilde;es do Servidor';
$HEADING['TEMPLATE_DETAILS'] = 'Detalhes do Tema (Template)';
$HEADING['UNINSTALL_LANGUAGE'] = 'Desinstalar Idioma';
$HEADING['UNINSTALL_MODULE'] = 'Desinstalar M&oacute;dulo';
$HEADING['UNINSTALL_TEMPLATE'] = 'Desinstalar Tema (Template)';
$HEADING['UPGRADE_LANGUAGE'] = 'Language register/upgrading';
$HEADING['UPLOAD_FILES'] = 'Enviar Arquivo(s)';
$HEADING['WBMAILER_SETTINGS'] = 'Mailer Settings';
$MESSAGE['ADDON_ERROR_RELOAD'] = 'Error while updating the Add-On information.';
$MESSAGE['ADDON_LANGUAGES_RELOADED'] = 'Languages reloaded successfully';
$MESSAGE['ADDON_MANUAL_FTP_LANGUAGE'] = '<strong>ATTENTION!</strong> For safety reasons uploading languages files in the folder/languages/ only by FTP and use the Upgrade function for registering or updating.';
$MESSAGE['ADDON_MANUAL_FTP_WARNING'] = 'Warning: Existing module database entries will get lost. ';
$MESSAGE['ADDON_MANUAL_INSTALLATION'] = 'When modules are uploaded via FTP (not recommended), the module installation functions <tt>install</tt>, <tt>upgrade</tt> or <tt>uninstall</tt> will not be executed automatically. Those modules may not work correct or do not uninstall properly.<br /><br />You can execute the module functions manually for modules uploaded via FTP below.';
$MESSAGE['ADDON_MANUAL_INSTALLATION_WARNING'] = 'Warning: Existing module database entries will get lost. Only use this option if you experience problems with modules uploaded via FTP.';
$MESSAGE['ADDON_MANUAL_RELOAD_WARNING'] = 'Warning: Existing module database entries will get lost. ';
$MESSAGE['ADDON_MODULES_RELOADED'] = 'Modules reloaded successfully';
$MESSAGE['ADDON_OVERWRITE_NEWER_FILES'] = 'Overwrite newer Files';
$MESSAGE['ADDON_PRECHECK_FAILED'] = 'Add-on installation failed. Your system does not fulfill the requirements of this Add-on. To make this Add-on working on your system, please fix the issues summarized below.';
$MESSAGE['ADDON_RELOAD'] = 'Update database with information from Add-on files (e.g. after FTP upload).';
$MESSAGE['ADDON_TEMPLATES_RELOADED'] = 'Templates reloaded successfully';
$MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES'] = 'Privil&eacute;gios Insuficientes para estar aqui';
$MESSAGE['FORGOT_PASS_ALREADY_RESET'] = 'A senha n&atilde;o pode ser redefinida mais de uma vez por hora, desculpe';
$MESSAGE['FORGOT_PASS_CANNOT_EMAIL'] = 'N&atilde;o foi poss&iacute;vel enviar a senha, favor contatar o administrador do sistema';
$MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND'] = 'O email informado n&atilde;o pode ser encontrado no banco de dados';
$MESSAGE['FORGOT_PASS_NO_DATA'] = 'Favor inserir seu email abaixo';
$MESSAGE['FORGOT_PASS_PASSWORD_RESET'] = 'Your loginname and password have been sent to your email address';
$MESSAGE['FRONTEND_SORRY_NO_ACTIVE_SECTIONS'] = 'Sorry, no active content to display';
$MESSAGE['FRONTEND_SORRY_NO_VIEWING_PERMISSIONS'] = 'Desculpe, voc&ecirc; n&atilde;o tem permiss&atilde;o para ver essa p&aacute;gina';
$MESSAGE['GENERIC_ALREADY_INSTALLED'] = 'J&aacute; est&aacute; instalado';
$MESSAGE['GENERIC_BAD_PERMISSIONS'] = 'N&atilde;o foi poss&iacute;vel gravar no diret&oacute;rio de destino';
$MESSAGE['GENERIC_BE_PATIENT'] = 'Please be patient.';
$MESSAGE['GENERIC_CANNOT_UNINSTALL'] = 'N&atilde;o foi poss&iacute;vel desinstalar';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE'] = 'N&atilde;o foi poss&iacute;vel desinstalar: O arquivo selecionado est&aacute; em uso';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL'] = '<br /><br />O m&oacute;dulo n&atilde;o <b>{{type_name}}</b> pode ser desinstalado porque est&aacute; a ser utilizado {{pages}}.<br /><br />';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL_PAGES'] = 'na seguinte p&aacute;gina;nas seguintes p&aacute;ginas';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_TEMPLATE'] = 'O Template n&atilde;o pode ser desinstalado porque &eacute; o Template padr&atilde;o';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_THEME'] = 'Can\'t uninstall the template <b>{{name}}</b>, because it is the default backend theme!';
$MESSAGE['GENERIC_CANNOT_UNZIP'] = 'N&atilde;o foi poss&iacute;vel descompactar';
$MESSAGE['GENERIC_CANNOT_UPLOAD'] = 'N&atilde;o foi poss&iacute;vel enviar o arquivo';
$MESSAGE['GENERIC_COMPARE'] = ' successfully';
$MESSAGE['GENERIC_ERROR_OPENING_FILE'] = 'Erro ao abrir o arquivo.';
$MESSAGE['GENERIC_FAILED_COMPARE'] = ' failed';
$MESSAGE['GENERIC_FILE_TYPE'] = 'O arquivo a ser enviado precisa ser do seguinte formato:';
$MESSAGE['GENERIC_FILE_TYPES'] = 'O arquivo a ser enviado precisa ser de algum dos seguintes formatos:';
$MESSAGE['GENERIC_FILL_IN_ALL'] = 'Favor retornar e preencher todos os campos';
$MESSAGE['GENERIC_FORGOT_OPTIONS'] = 'You have selected no choice!';
$MESSAGE['GENERIC_INSTALLED'] = 'Instalado com Sucesso';
$MESSAGE['GENERIC_INVALID'] = 'O arquivo enviado &eacute; inv&aacute;lido';
$MESSAGE['GENERIC_INVALID_ADDON_FILE'] = 'Invalid WebsiteBaker installation file. Please check the *.zip format.';
$MESSAGE['GENERIC_INVALID_LANGUAGE_FILE'] = 'Invalid WebsiteBaker language file. Please check the text file.';
$MESSAGE['GENERIC_INVALID_MODULE_FILE'] = 'Invalid WebsiteBaker module file. Please check the text file.';
$MESSAGE['GENERIC_INVALID_TEMPLATE_FILE'] = 'Invalid WebsiteBaker template file. Please check the text file.';
$MESSAGE['GENERIC_IN_USE'] = ' but used in ';
$MESSAGE['GENERIC_MISSING_ARCHIVE_FILE'] = 'Missing Archiv file!';
$MESSAGE['GENERIC_MODULE_VERSION_ERROR'] = 'The module is not installed properly!';
$MESSAGE['GENERIC_NOT_COMPARE'] = ' not possibly';
$MESSAGE['GENERIC_NOT_INSTALLED'] = 'N&atilde;o Instalado';
$MESSAGE['GENERIC_NOT_UPGRADED'] = 'Actualization not possibly';
$MESSAGE['GENERIC_PLEASE_BE_PATIENT'] = 'Aguarde, isso pode levar algum tempo.';
$MESSAGE['GENERIC_PLEASE_CHECK_BACK_SOON'] = 'Favor retornar em breve...';
$MESSAGE['GENERIC_SECURITY_ACCESS'] = 'Security offense!! Access denied!';
$MESSAGE['GENERIC_SECURITY_OFFENSE'] = 'Security offense!! data storing was refused!!';
$MESSAGE['GENERIC_UNINSTALLED'] = 'Desinstalado com Sucesso';
$MESSAGE['GENERIC_UPGRADED'] = 'Atualizado com Sucesso';
$MESSAGE['GENERIC_VERSION_COMPARE'] = 'Version comparison';
$MESSAGE['GENERIC_VERSION_GT'] = 'Upgrade necessary!';
$MESSAGE['GENERIC_VERSION_LT'] = 'Downgrade';
$MESSAGE['GENERIC_WEBSITE_LOCKED'] = 'this site is temporarily down for maintenance';
$MESSAGE['GENERIC_WEBSITE_UNDER_CONSTRUCTION'] = 'Website Em Constru&ccdil;&atilde;o';
$MESSAGE['GROUPS_ADDED'] = 'Grupo adicionado com sucesso';
$MESSAGE['GROUPS_CONFIRM_DELETE'] = 'Voc&ecirc; tem certeza que deseja apagar o grupo selecionado (e usu&aacute;rios pertencentes ao grupo)?';
$MESSAGE['GROUPS_DELETED'] = 'Grupo apagado com sucesso';
$MESSAGE['GROUPS_GROUP_NAME_BLANK'] = 'O nome do grupo est&aacute; em branco';
$MESSAGE['GROUPS_GROUP_NAME_EXISTS'] = 'Nome do Grupo j&aacute; existe';
$MESSAGE['GROUPS_NO_GROUPS_FOUND'] = 'N&atilde;o foram encotrados grupos';
$MESSAGE['GROUPS_SAVED'] = 'Grupo armazenado com sucesso';
$MESSAGE['LOGIN_AUTHENTICATION_FAILED'] = 'Loginname or password incorrect';
$MESSAGE['LOGIN_BOTH_BLANK'] = 'Please enter your loginname and password below';
$MESSAGE['LOGIN_PASSWORD_BLANK'] = 'Favor Inserir a senha';
$MESSAGE['LOGIN_PASSWORD_TOO_LONG'] = 'A senha fornecida &eacute; longa demais';
$MESSAGE['LOGIN_PASSWORD_TOO_SHORT'] = 'A senha fornecida &eacute; curta demais';
$MESSAGE['LOGIN_USERNAME_BLANK'] = 'Please enter a loginname';
$MESSAGE['LOGIN_USERNAME_TOO_LONG'] = 'Supplied loginname to long';
$MESSAGE['LOGIN_USERNAME_TOO_SHORT'] = 'Supplied loginname to short';
$MESSAGE['MEDIA_BLANK_EXTENSION'] = 'Voc&ecirc; n&atilde;o inseriou uma extens&atilde;o de arquivo';
$MESSAGE['MEDIA_BLANK_NAME'] = 'Voc&ecirc; n&atilde;o inseriu um nome novo';
$MESSAGE['MEDIA_CANNOT_DELETE_DIR'] = 'N&atilde;o foi poss&iacute;vel apagar a pasta selecionada';
$MESSAGE['MEDIA_CANNOT_DELETE_FILE'] = 'N&atilde;o foi poss&iacute;vel apagar o arquivo selecionado';
$MESSAGE['MEDIA_CANNOT_RENAME'] = 'Erro ao Renomear';
$MESSAGE['MEDIA_CONFIRM_DELETE'] = 'Tem certeza que deseja apagar o seguinte arquivo ou pasta?';
$MESSAGE['MEDIA_DELETED_DIR'] = 'Pasta apagada com sucesso';
$MESSAGE['MEDIA_DELETED_FILE'] = 'Arquivo apagado com sucesso';
$MESSAGE['MEDIA_DIR_ACCESS_DENIED'] = 'Specified directory does not exist or is not allowed.';
$MESSAGE['MEDIA_DIR_DOES_NOT_EXIST'] = 'Diret&oacute;rio n&atilde;o existe';
$MESSAGE['MEDIA_DIR_DOT_DOT_SLASH'] = 'N&atilde;o foi poss&iacute;vel incluir ../ no nome da pasta';
$MESSAGE['MEDIA_DIR_EXISTS'] = 'Uma pasta com esse nome j&aacute; existe';
$MESSAGE['MEDIA_DIR_MADE'] = 'Pasta criada com sucesso';
$MESSAGE['MEDIA_DIR_NOT_MADE'] = 'N&atilde;o foi poss&iacute;vel criar a pasta';
$MESSAGE['MEDIA_FILE_EXISTS'] = 'Um arquivo com esse nome j&aacute; existe';
$MESSAGE['MEDIA_FILE_NOT_FOUND'] = 'Arquivo n&atilde;o encontrado';
$MESSAGE['MEDIA_NAME_DOT_DOT_SLASH'] = 'N&atilde;o foi possivel incluir ../ no nome';
$MESSAGE['MEDIA_NAME_INDEX_PHP'] = 'N&atilde;o &eacute; possivel usar index.php como nome';
$MESSAGE['MEDIA_NONE_FOUND'] = 'Nenhuma arquivo de m&iacute;dia encontrado na pasta atual';
$MESSAGE['MEDIA_NO_FILE_UPLOADED'] = 'No file was recieved';
$MESSAGE['MEDIA_RENAMED'] = 'Renomeado com sucesso';
$MESSAGE['MEDIA_SINGLE_UPLOADED'] = ' arquivo enviado com sucesso';
$MESSAGE['MEDIA_TARGET_DOT_DOT_SLASH'] = 'N&atilde;o pode possuir ../ na pasta alvo';
$MESSAGE['MEDIA_UPLOADED'] = ' arquivos enviados com sucesso';
$MESSAGE['MOD_FORM_EXCESS_SUBMISSIONS'] = 'Desculpe, este formul&aacute;rio foi submetido v&aacute;rias vezes nessa hora. Favor tentar novamente dentro de uma hora.';
$MESSAGE['MOD_FORM_INCORRECT_CAPTCHA'] = 'O N&uacute;mero de Verifica&ccdil;&atilde;o (conhecido como Captcha) que voc&ecirc; entrou, &eacute; inv&aacute;lido. Se estiver tendo problemas usando o Captcha, envie uma mensagem para: <a href="mailto:{SERVER_EMAIL}">{SERVER_EMAIL}</a>';
$MESSAGE['MOD_FORM_REQUIRED_FIELDS'] = 'Voc&ecirc; precisa preencher os seguintes campos';
$MESSAGE['PAGES_ADDED'] = 'P&aacute;gina adicionada com sucesso';
$MESSAGE['PAGES_ADDED_HEADING'] = 'Cabe&ccdil;alho da P&aacute;gina adicionado com sucesso.';
$MESSAGE['PAGES_BLANK_MENU_TITLE'] = 'Favor Inserir T&iacute;tulo do Menu';
$MESSAGE['PAGES_BLANK_PAGE_TITLE'] = 'Favor Inserir T&iacute;tulo da P&aacute;gina';
$MESSAGE['PAGES_CANNOT_CREATE_ACCESS_FILE'] = 'Erro ao criar o arquivo no diret&oacute;rio /pages (Privil&eacute;gios Insuficientes)';
$MESSAGE['PAGES_CANNOT_DELETE_ACCESS_FILE'] = 'Erro ao apagar o arquivo no diret&oacute;rio /pages (Privil&eacute;gios Insuficientes)';
$MESSAGE['PAGES_CANNOT_REORDER'] = 'Erro na re-ordena&ccdil;&atilde;o da p&aacute;gina';
$MESSAGE['PAGES_DELETED'] = 'P&aacute;gina apagada com sucesso';
$MESSAGE['PAGES_DELETE_CONFIRM'] = 'Tem certeza que deseja apagar a p&aacute;gina selecionada(e todas as suas sub-p&aacute;ginas)';
$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS'] = 'Voc&ecirc; n&atilde;o tem permiss&atilde;o para Modificar essa p&aacute;gina';
$MESSAGE['PAGES_INTRO_LINK'] = 'Clique AQUI para modificar a P&aacute;gina de Introdu&ccdil;&atilde;o';
$MESSAGE['PAGES_INTRO_NOT_WRITABLE'] = 'N&atilde;o foi poss&iacute;vel gravar o arquivo /pages/intro.php (Privil&eacute;gios Insuficientes)';
$MESSAGE['PAGES_INTRO_SAVED'] = 'P&aacute;gina de Introdu&ccdil;&atilde;o armazenada com sucesso';
$MESSAGE['PAGES_LAST_MODIFIED'] = '&Uacute;ltima modifica&ccdil;&atilde;o por';
$MESSAGE['PAGES_NOT_FOUND'] = 'P&aacute;gina n&atilde;o encontrada';
$MESSAGE['PAGES_NOT_SAVED'] = 'Erro ao armazenar a p&aacute;gina';
$MESSAGE['PAGES_PAGE_EXISTS'] = 'Uma p&aacute;gina com o mesmo nome ou similar j&aacute; existe';
$MESSAGE['PAGES_REORDERED'] = 'Re-ordena&ccdil;&atilde;o feita com sucesso';
$MESSAGE['PAGES_RESTORED'] = 'Pagina Restaurada com sucesso';
$MESSAGE['PAGES_RETURN_TO_PAGES'] = 'Retornar &agrave; P&aacute;ginas';
$MESSAGE['PAGES_SAVED'] = 'P&aacute;gina armazenada com sucesso';
$MESSAGE['PAGES_SAVED_SETTINGS'] = 'Configura&ccdil;&otilde;es de P&aacute;gina armazenadas com sucesso';
$MESSAGE['PAGES_SECTIONS_PROPERTIES_SAVED'] = 'Propriedades da Sess&atilde;o foram armazenadas com sucesso';
$MESSAGE['PREFERENCES_CURRENT_PASSWORD_INCORRECT'] = 'A senha(atual) informada n&atilde;o est&aacute; correta';
$MESSAGE['PREFERENCES_DETAILS_SAVED'] = 'Detalhes armazenados  com sucesso';
$MESSAGE['PREFERENCES_EMAIL_UPDATED'] = 'Email atualizado com sucesso';
$MESSAGE['PREFERENCES_INVALID_CHARS'] = 'Invalid password chars used';
$MESSAGE['PREFERENCES_PASSWORD_CHANGED'] = 'Senha alterada com sucesso';
$MESSAGE['RECORD_MODIFIED_FAILED'] = 'The change of the record has missed.';
$MESSAGE['RECORD_MODIFIED_SAVED'] = 'The changed record was updated successfully.';
$MESSAGE['RECORD_NEW_FAILED'] = 'Adding a new record has missed.';
$MESSAGE['RECORD_NEW_SAVED'] = 'New record was added successfully.';
$MESSAGE['SETTINGS_MODE_SWITCH_WARNING'] = 'Aten&ccdil;&atilde;o: Pressionando esse bot&atilde;o, todas as altera&ccdil;&otilde;es n&atilde;o salvas, ser&atilde;o perdidas';
$MESSAGE['SETTINGS_SAVED'] = 'Altera&ccdil;&otilde;es armazenadas com sucesso';
$MESSAGE['SETTINGS_UNABLE_OPEN_CONFIG'] = 'N&atilde;o foi possivel abrir o arquivo de configura&ccdil;&atilde;o';
$MESSAGE['SETTINGS_UNABLE_WRITE_CONFIG'] = 'N&atilde;o foi possivel gravar no aquivo de configura&ccdil;&atilde;o';
$MESSAGE['SETTINGS_WORLD_WRITEABLE_WARNING'] = 'Aten&ccdil;&atilde;o: Somente recomendado para ambientes de teste';
$MESSAGE['SIGNUP2_ADMIN_INFO'] = '
A new user was registered.

Loginname: {LOGIN_NAME}
UserId: {LOGIN_ID}
E-Mail: {LOGIN_EMAIL}
IP-Adress: {LOGIN_IP}
Registration date: {SIGNUP_DATE}
----------------------------------------
This message was automatic generated!

';
$MESSAGE['SIGNUP2_BODY_LOGIN_FORGOT'] = '
Hello {LOGIN_DISPLAY_NAME},

This mail was sent because the \'forgot password\' function has been applied to your account.

Your new \'{LOGIN_WEBSITE_TITLE}\' login details are:

Loginname: {LOGIN_NAME}
Password: {LOGIN_PASSWORD}

Your password has been reset to the one above.
This means that your old password will no longer work anymore!
If you\'ve got any questions or problems within the new login-data
you should contact the website-team or the admin of \'{LOGIN_WEBSITE_TITLE}\'.
Please remember to clean you browser-cache before using the new one to avoid unexpected fails.

Regards
------------------------------------
This message was automatic generated

';
$MESSAGE['SIGNUP2_BODY_LOGIN_INFO'] = '
Hello {LOGIN_DISPLAY_NAME},

Welcome to our \'{LOGIN_WEBSITE_TITLE}\'.

Your \'{LOGIN_WEBSITE_TITLE}\' login details are:
Loginname: {LOGIN_NAME}
Password: {LOGIN_PASSWORD}

Regards

Please:
if you have received this message by an error, please delete it immediately!
-------------------------------------
This message was automatic generated!
';
$MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO'] = 'Your login details...';
$MESSAGE['SIGNUP_NO_EMAIL'] = 'Voc&ecirc; precisa informar um endere&ccdil;o de email';
$MESSAGE['START_CURRENT_USER'] = 'Voc&ecirc; est&aacute; logado como:';
$MESSAGE['START_INSTALL_DIR_EXISTS'] = 'Aviso, O diret&oacute;rio "INSTALL" ainda existe!';
$MESSAGE['START_UPGRADE_SCRIPT_EXISTS'] = 'Please delete the file "upgrade-script.php" from your webspace.';
$MESSAGE['START_WELCOME_MESSAGE'] = 'Bem-Vindo &agrave; Administra&ccdil;&atilde;o do WebsiteBaker';
$MESSAGE['TEMPLATES_CHANGE_TEMPLATE_NOTICE'] = 'Aten&ccdil;&atilde;o: para alterar o tema (template) voc&ecirc; precisa ir at&eacute; a sess&atilde;o Configura&ccdil;&otilde;es';
$MESSAGE['THEME_ALREADY_EXISTS'] = 'This new theme descriptor already exists.';
$MESSAGE['THEME_COPY_CURRENT'] = 'Copy the current active theme and save it with a new name.';
$MESSAGE['THEME_DESTINATION_READONLY'] = 'No rights to create new theme directory!';
$MESSAGE['THEME_IMPORT_HTT'] = 'Import additional templates into the current active theme.<br />Use these templates to overwrite the corresponding default template.';
$MESSAGE['THEME_INVALID_SOURCE_DESTINATION'] = 'Invalid descriptor for the new theme given!';
$MESSAGE['UNKNOW_UPLOAD_ERROR'] = 'Unknown upload error';
$MESSAGE['UPLOAD_ERR_CANT_WRITE'] = 'Failed to write file to disk';
$MESSAGE['UPLOAD_ERR_EXTENSION'] = 'File upload stopped by extension';
$MESSAGE['UPLOAD_ERR_FORM_SIZE'] = 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form';
$MESSAGE['UPLOAD_ERR_INI_SIZE'] = 'The uploaded file exceeds the upload_max_filesize directive in php.ini';
$MESSAGE['UPLOAD_ERR_NO_FILE'] = 'No file was uploaded';
$MESSAGE['UPLOAD_ERR_NO_TMP_DIR'] = 'Missing a temporary folder';
$MESSAGE['UPLOAD_ERR_OK'] = 'File were successful uploaded';
$MESSAGE['UPLOAD_ERR_PARTIAL'] = 'The uploaded file was only partially uploaded';
$MESSAGE['USERS_ADDED'] = 'Usu&aacute;rio adicionado com sucesso';
$MESSAGE['USERS_CANT_SELFDELETE'] = 'Function rejected, You can not delete yourself!';
$MESSAGE['USERS_CHANGING_PASSWORD'] = 'Aten&ccdil;&atilde;o: Voc&ecirc; deve preencher os campos abaixo se deseja alterar a senha';
$MESSAGE['USERS_CONFIRM_DELETE'] = 'Voc&ecirc; tem certeza que deseja apagar o usu&aacute;rio selecionado?';
$MESSAGE['USERS_DELETED'] = 'Usu&aacute;rio apagado com sucesso';
$MESSAGE['USERS_EMAIL_TAKEN'] = 'O endere&ccdil;o de email informado j&aacute; est&aacute; sendo utilizado';
$MESSAGE['USERS_INVALID_EMAIL'] = 'O email fornecido &eacute; inv&aacute;lido';
$MESSAGE['USERS_NAME_INVALID_CHARS'] = 'Invalid chars for Loginname found';
$MESSAGE['USERS_NO_GROUP'] = 'Nenhum grupo selecionado';
$MESSAGE['USERS_PASSWORD_MISMATCH'] = 'As senhas fornecidas n&atilde;o conferem';
$MESSAGE['USERS_PASSWORD_TOO_SHORT'] = 'A senha fornecida &eacute; curta demais';
$MESSAGE['USERS_SAVED'] = 'Usu&aacute;rio armazenado com sucesso';
$MESSAGE['USERS_USERNAME_TAKEN'] = 'The loginname you entered is already taken';
$MESSAGE['USERS_USERNAME_TOO_SHORT'] = 'The loginname you entered was too short';
$OVERVIEW['ADMINTOOLS'] = 'Access the WebsiteBaker administration tools...';
$OVERVIEW['GROUPS'] = 'Gerencie os grupos de usu&aacute;rios e suas permiss&otilde;es de sistema...';
$OVERVIEW['HELP'] = 'D&uacute;vidas? Encontre respostas...';
$OVERVIEW['LANGUAGES'] = 'Gerencie os idiomas do seu website...';
$OVERVIEW['MEDIA'] = 'Gerencie os arquivos armazenados na pasta Media...';
$OVERVIEW['MODULES'] = 'Gerencie os M&oacute;dulos do WebsiteBaker...';
$OVERVIEW['PAGES'] = 'Gerencie as P&aacute;ginas do seu site...';
$OVERVIEW['PREFERENCES'] = 'Altere suas prefer&ecirc;ncias como email, senha, etc... ';
$OVERVIEW['SETTINGS'] = 'Altere as configura&ccdil;&otilde;es do WebsiteBaker...';
$OVERVIEW['START'] = 'Vis&atilde;o Geral da Administra&ccdil;&atilde;o';
$OVERVIEW['TEMPLATES'] = 'Altere a apar&ecirc;ncia do seu site com temas(templates)...';
$OVERVIEW['USERS'] = 'Gerencie os usu&aacute;rios que podem logar no WebsiteBaker...';
$OVERVIEW['VIEW'] = 'Visualize e navegue em seu website atrav&eacute;s de uma nova janela...';

/* include old languages format */
if(file_exists(WB_PATH.'/languages/old.format.inc.php'))
{
	include(WB_PATH.'/languages/old.format.inc.php');
}
