<?php

/*

 Website Baker Project <http://www.websitebaker.org/>
 Copyright (C) 2004-2006, Ryan Djurovich

 Website Baker is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Website Baker is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Website Baker; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

require('../../config.php');
require('pngthumb.php');

// Get id
if(!isset($_POST['image_id']) OR !is_numeric($_POST['image_id'])) {
	header("Location: ".ADMIN_URL."/pages/index.php");
} else {
	$id = $_POST['image_id'];
	$image_id = $id;
}

// Include WB admin wrapper script
$update_when_modified = true; // Tells script to update when this page was last updated
require(WB_PATH.'/modules/admin.php');

// Validate all fields
if($admin->get_post('title') == '' AND $admin->get_post('url') == '') {
	$admin->print_error($MESSAGE['GENERIC']['FILL_IN_ALL'], WB_URL.'/modules/FancyBraxBox/modify_image.php?page_id='.$page_id.'&section_id='.$section_id.'&image_id='.$id);
} else {
	$title = addslashes($admin->get_post('title'));
	$alttitle = addslashes($admin->get_post('alttitle'));
	$description = addslashes($admin->get_post('description'));
	$active = $admin->get_post('active');
	$old_link = $admin->get_post('link');
}

// Get page link URL
$query_page = $database->query("SELECT level,link FROM ".TABLE_PREFIX."pages WHERE page_id = '$page_id'");
$page = $query_page->fetchRow();
$page_level = $page['level'];
$page_link = $page['link'];

// Include WB functions file
require(WB_PATH.'/framework/functions.php');

// Work-out what the link should be
$image_link = PAGES_DIRECTORY.'/FancyBraxBox/'.page_filename($title).$image_id;

// Make sure the post link is set and exists
// Make news post access files dir
make_dir(WB_PATH.PAGES_DIRECTORY.'/FancyBraxBox/');
if(!is_writable(WB_PATH.PAGES_DIRECTORY.'/FancyBraxBox/')) {
	$admin->print_error($MESSAGE['PAGES']['CANNOT_CREATE_ACCESS_FILE']);
} elseif($old_link != $image_link OR !file_exists($image_link)) {
	// We need to create a new file
	// First, delete old file if it exists
	if(file_exists(WB_PATH.$old_link.'.php')) {
		unlink(WB_PATH.$old_link.'.php');
	}
	// Specify the filename
	$filename = WB_PATH.'/'.$image_link.'.php';
	// The depth of the page directory in the directory hierarchy
	// '/pages' is at depth 1
	$pages_dir_depth=count(explode('/',PAGES_DIRECTORY))-1;
	// Work-out how many ../'s we need to get to the index page
	$index_location = '../';
	for($i = 0; $i < $pages_dir_depth; $i++) {
		$index_location .= '../';
	}
	// Write to the filename
	$content = ''.
'<?php
$page_id = '.$page_id.';
$section_id = '.$section_id.';
$image_id = '.$image_id.';
define("IMAGE_ID", $image_id);
require("'.$index_location.'config.php");
require(WB_PATH."/index.php"); 
?>';
	$handle = fopen($filename, 'w');
	fwrite($handle, $content);
	fclose($handle);
	change_mode($filename);
}

// Check if the user uploaded an image or wants to delete one
if(isset($_FILES['image']['tmp_name']) AND $_FILES['image']['tmp_name'] != '') {
	// Get real filename and set new filename
	$filename = $_FILES['image']['name'];
	$path_parts = pathinfo($filename);
	$fileext = strtolower($path_parts['extension']);
	$new_filename = WB_PATH.MEDIA_DIRECTORY.'/FancyBraxBox_gallery/image'.$image_id.'.'.$fileext;
	
	// Make sure the image is a jpg file
	if(!($fileext == "jpg" || $fileext == "jpeg" || $fileext == "png")) {
		$admin->print_error($MESSAGE['GENERIC']['FILE_TYPE'].' JPG / JPEG / PNG');
	}
	
	// Make sure the target directory exists
	make_dir(WB_PATH.MEDIA_DIRECTORY.'/FancyBraxBox_gallery');
	
	// Upload image
	move_uploaded_file($_FILES['image']['tmp_name'], $new_filename);
	change_mode($new_filename);
	
	// Check if we need to create a thumb
	$query_settings = $database->query("SELECT thmb_resize FROM ".TABLE_PREFIX."mod_fancybrax_settings WHERE section_id = '$section_id'");
	$fetch_settings = $query_settings->fetchRow();
	$resize = $fetch_settings['thmb_resize'];
	if($resize != 0) {
		// Resize the image
		$thumb_location = WB_PATH.MEDIA_DIRECTORY.'/FancyBraxBox_gallery/thumb'.$image_id.'.jpg';
		
		// check thumbnail type
		if(!($fileext == "png")) {
			make_thumb($new_filename, $thumb_location, $resize);
		} else {
			make_thumb_png($new_filename, $thumb_location, $resize);
		}
		change_mode($thumb_location);
	}
	
	
	// Check if we need to create a main image
	$query_settings = $database->query("SELECT main_resize FROM ".TABLE_PREFIX."mod_fancybrax_settings WHERE section_id = '$section_id'");
	$fetch_settings = $query_settings->fetchRow();
	$resize = $fetch_settings['main_resize'];
	if($resize != 0) {
		// Resize the image
		$main_location = WB_PATH.MEDIA_DIRECTORY.'/FancyBraxBox_gallery/main'.$image_id.'.jpg';
		
		// check thumbnail type
		if(!($fileext == "png")) {
			make_thumb($new_filename, $main_location, $resize);
		} else {
			make_thumb_png($new_filename, $main_location, $resize);
		}
		change_mode($main_location);
	}
	
	// update file extension in the database
	$database->query("UPDATE ".TABLE_PREFIX."mod_fancybrax_images SET extension = '$fileext' WHERE image_id = '$image_id'");
}
if(isset($_POST['delete_image']) AND $_POST['delete_image'] != '') {
	// query the database for the image extension
	$query_content = $database->query("SELECT extension FROM ".TABLE_PREFIX."mod_fancybrax_images WHERE image_id = '$image_id'");
	$fetch_content = $query_content->fetchRow();
	$ext = $fetch_content['extension'];

	// Try unlinking image
	if(file_exists(WB_PATH.MEDIA_DIRECTORY.'/FancyBraxBox_gallery/image'.$image_id.'.'.$ext)) {
		unlink(WB_PATH.MEDIA_DIRECTORY.'/FancyBraxBox_gallery/image'.$image_id.'.'.$ext);
	}
}

// Update row
$database->query("UPDATE ".TABLE_PREFIX."mod_fancybrax_images SET title = '$title', link = '$image_link', `description` = '$description', active = '$active', modified_when = '".mktime()."', modified_by = '".$admin->get_user_id()."', alttitle = '$alttitle' WHERE image_id = '$image_id'");

// Check if there is a db error, otherwise say successful
if($database->is_error()) {
	$admin->print_error($database->get_error(), WB_URL.'/modules/FancyBraxBox/modify_image.php?page_id='.$page_id.'&section_id='.$section_id.'&image_id='.$id);
} else {
	$admin->print_success($TEXT['SUCCESS'], ADMIN_URL.'/pages/modify.php?page_id='.$page_id);
}

// Print admin footer
$admin->print_footer();

?>