<?php

/*

 Website Baker Project <http://www.websitebaker.org/>
 Copyright (C) 2004-2006, Ryan Djurovich

 Website Baker is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Website Baker is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Website Baker; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

class GD { 
	var $width = 0;
	var $height = 0;
	var $new_width = 0;
	var $new_height = 0;
	var $file;
	var $new_file;
	
	// Set the images filename and path.
	function setFile($file) {
		$this->file = $file;
	}
	
	// Set the new images filename and path.
	function setNewFile($file) {
		$this->new_file = $file;
	}
	
	// Get the size (x and y) of the image.
	function getImageInfo()	{
		$image_info = getimagesize($this->file);
		$this->width = $image_info[0];
		$this->height = $image_info[1];
	}

	// Calculate the height and width of the new image.
	function calcSize($new_width) {
		$ratio = $this->width / $new_width;
		$this->new_width = $new_width;
		$this->new_height = $this->height / $ratio;
	}								
	
	// Calculate the height and width of the new thumb.
	function calcSize_thumb($new_width) {
		//Make sure thumb does not exceed defined max in either height or width
		if ($this->width >= $this->height) {
			$ratio = $this->width / $new_width;
			$this->new_width = $new_width;
			$this->new_height = $this->height / $ratio;
		} else {
			$ratio = $this->height / $new_width;
			$this->new_height = $new_width;
			$this->new_width = $this->width / $ratio;
		}
	}	
	
	// Create the new image file.
	function createImage() {
		// Check what type of image it is.
		$image_info = getimagesize($this->file);
		$type = $image_info[2];
		switch ($type) {
			case 1:
			// Create source image.
			$image = imagecreatefromgif($this->file);
			break;
			case 2:
		    // Create source image.
			$image = imagecreatefromjpeg($this->file);
			break;
			case 3:
			// Create source image.
			$image = imagecreatefrompng($this->file);
			break;
		}
		// Check if we can use the newer GD functions if so use them.
		if ($gdv = $this->gdVersion()) {
			if ($gdv >=2) {
				$image_s = imagecreatetruecolor($this->new_width, $this->new_height);
				imagecopyresampled($image_s, $image, 0, 0, 0, 0, $this->new_width, $this->new_height, $this->width, $this->height);
			} else {
				$image_s = imagecreate($this->new_width, $this->new_height);
				imagecopyresized($image_s, $image, 0, 0, 0, 0, $this->new_width, $this->new_height, $this->width, $this->height);
			}
		} else {
			echo "The GD extension isn't loaded.";
		}
		switch ($type) {
			case 1:
				imagegif($image_s, $this->new_file );
				break;
			
			case 2:
				imagejpeg($image_s, $this->new_file, 100);
				break;
			
			case 3:
				imagepng($image_s, $this->new_file );
				break;
		}
		
		ImageDestroy($image_s);
	}	
	
	function clearCache($path) {
		// Create file handle for the cache directory.
		$ch = opendir($path);
		// Read files in cache directory.
		while (false !== ($file = readdir($ch))) {
			// Skip the . and .. entries.
			if ($file != '.' && $file != '..') {
				// Delete files.
				unlink($path.$file);
			}
		}	
	}
	
	function gdVersion() {
		if (! extension_loaded('gd')) {
			return;
		}
		static $gd_ver = 0;
		// Use the static variable if function was called previously.
		if ($gd_ver > 0 ) {
			return $gd_ver;
		}
		// Use the gd_info() function if possible.
		if (function_exists('gd_info')) {
			$ver_info = gd_info();
			preg_match('/\d/', $ver_info['GD Version'], $match);
			$gd_ver = $match[0];
			return $match[0];
		}
		// If phpinfo() is disabled use a specified / fail-safe choice...
		if (preg_match('/phpinfo/', ini_get('disable_functions'))) {
			$gd_ver = 1;
			return 1;
		}
		// ...otherwise use phpinfo().
		ob_start();
		phpinfo(8);
		$info = ob_get_contents();
		ob_end_clean();
		$info = stristr($info, 'gd version');
		preg_match('/\d/', $info, $match);
		$gd_ver = $match[0];
		return $match[0];
	} 

}

?>